#include "meeting_sdk_impl.h"
#include <assert.h>

typedef JMResult (*PFEventCallbackSet)(const char *pEventName, void *pfFuncCallBack);
typedef JMResult (*PFFunctionGet)(const char *pFunctionName, void **pfFunc);


/***
*	IJMIMCallbackImpl
***/
IJMIMCallbackImpl::IJMIMCallbackImpl()
{
	mpfOnRecv_DSInvitation = NULL;
	mpfOnRecv_DSDecline = NULL;
	mpfOnRecv_DSCancelled = NULL;
	mpfOnRecv_MeetingInvitation = NULL;
	mpfOnRecv_MeetingDecline = NULL;
	mpfOnRecv_MeetingCancelled = NULL;
	mpfOnRecv_IMAlert = NULL;
}

IJMIMCallbackImpl::~IJMIMCallbackImpl()
{
}

void IJMIMCallbackImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IJMIMCallback_OnRecv_DSInvitation, (void**)&mpfOnRecv_DSInvitation);
	jmResult = (*pfFunctionGet)(JMSDK_IJMIMCallback_OnRecv_DSDecline, (void**)&mpfOnRecv_DSDecline);
	jmResult = (*pfFunctionGet)(JMSDK_IJMIMCallback_OnRecv_DSCancelled, (void**)&mpfOnRecv_DSCancelled);
	jmResult = (*pfFunctionGet)(JMSDK_IJMIMCallback_OnRecv_MeetingInvitation, (void**)&mpfOnRecv_MeetingInvitation);
	jmResult = (*pfFunctionGet)(JMSDK_IJMIMCallback_OnRecv_MeetingDecline, (void**)&mpfOnRecv_MeetingDecline);
	jmResult = (*pfFunctionGet)(JMSDK_IJMIMCallback_OnRecv_MeetingCancelled, (void**)&mpfOnRecv_MeetingCancelled);
	jmResult = (*pfFunctionGet)(JMSDK_IJMIMCallback_OnRecv_IMAlert, (void**)&mpfOnRecv_IMAlert);
}

void IJMIMCallbackImpl::FuncUnInit()
{
	mpfOnRecv_DSInvitation = NULL;
	mpfOnRecv_DSDecline = NULL;
	mpfOnRecv_DSCancelled = NULL;
	mpfOnRecv_MeetingInvitation = NULL;
	mpfOnRecv_MeetingDecline = NULL;
	mpfOnRecv_MeetingCancelled = NULL;
	mpfOnRecv_IMAlert = NULL;
}

void IJMIMCallbackImpl::OnRecv_DSInvitation(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg)
{
	JMResult jmResult = (*mpfOnRecv_DSInvitation)(strAccountName, strSessionName, strCmdMsg);
	assert(jmResult == JMSucceed);
}

void IJMIMCallbackImpl::OnRecv_DSDecline(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg)
{
	JMResult jmResult = (*mpfOnRecv_DSDecline)(strAccountName, strSessionName, strCmdMsg);
	assert(jmResult == JMSucceed);
}

void IJMIMCallbackImpl::OnRecv_DSCancelled(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg)
{
	JMResult jmResult = (*mpfOnRecv_DSCancelled)(strAccountName, strSessionName, strCmdMsg);
	assert(jmResult == JMSucceed);
}

void IJMIMCallbackImpl::OnRecv_MeetingInvitation(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg)
{
	JMResult jmResult = (*mpfOnRecv_MeetingInvitation)(strAccountName, strSessionName, strCmdMsg);
	assert(jmResult == JMSucceed);
}

void IJMIMCallbackImpl::OnRecv_MeetingDecline(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg)
{
	JMResult jmResult = (*mpfOnRecv_MeetingDecline)(strAccountName, strSessionName, strCmdMsg);
	assert(jmResult == JMSucceed);
}

void IJMIMCallbackImpl::OnRecv_MeetingCancelled(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg)
{
	JMResult jmResult = (*mpfOnRecv_MeetingCancelled)(strAccountName, strSessionName, strCmdMsg);
	assert(jmResult == JMSucceed);
}

void IJMIMCallbackImpl::OnRecv_IMAlert(wstring& strAccountName, wstring& strSessionName, wstring& strCmdMsg)
{
	JMResult jmResult = (*mpfOnRecv_IMAlert)(strAccountName, strSessionName, strCmdMsg);
	assert(jmResult == JMSucceed);
}


/***
*	IJMCommonEventCallbackImpl
***/
IJMCommonEventCallbackImpl::IJMCommonEventCallbackImpl()
{
	mpfOnSignOn = NULL;
	mpfOnSignOff = NULL;
	mpfOnPreseceChange = NULL;
	mpfOnUserSignOff = NULL;
	mpfOnDSParamReady = NULL;
}

IJMCommonEventCallbackImpl::~IJMCommonEventCallbackImpl()
{
}

void IJMCommonEventCallbackImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IJMCommonEventCallback_OnSignOn, (void**)&mpfOnSignOn);
	jmResult = (*pfFunctionGet)(JMSDK_IJMCommonEventCallback_OnSignOff, (void**)&mpfOnSignOff);
	jmResult = (*pfFunctionGet)(JMSDK_IJMCommonEventCallback_OnPreseceChange, (void**)&mpfOnPreseceChange);
	jmResult = (*pfFunctionGet)(JMSDK_IJMCommonEventCallback_OnUserSignOff, (void**)&mpfOnUserSignOff);
	jmResult = (*pfFunctionGet)(JMSDK_IJMCommonEventCallback_OnDSParamReady, (void**)&mpfOnDSParamReady);
}

void IJMCommonEventCallbackImpl::FuncUnInit()
{
	mpfOnSignOn = NULL;
	mpfOnSignOff = NULL;
	mpfOnPreseceChange = NULL;
	mpfOnUserSignOff = NULL;
	mpfOnDSParamReady = NULL;
}

void IJMCommonEventCallbackImpl::OnSignOn()
{
	JMResult jmResult = (*mpfOnSignOn)();
	assert(jmResult == JMSucceed);
}

void IJMCommonEventCallbackImpl::OnSignOff()
{
	JMResult jmResult = (*mpfOnSignOff)();
	assert(jmResult == JMSucceed);
}

void IJMCommonEventCallbackImpl::OnPreseceChange()
{
	JMResult jmResult = (*mpfOnPreseceChange)();
	assert(jmResult == JMSucceed);
}

void IJMCommonEventCallbackImpl::OnUserSignOff(const wstring& strBuddyName)
{
	JMResult jmResult = (*mpfOnUserSignOff)(strBuddyName);
	assert(jmResult == JMSucceed);
}

void IJMCommonEventCallbackImpl::OnDSParamReady(const wstring& strDSURL, const wstring& strDSToken)
{
	JMResult jmResult = (*mpfOnDSParamReady)(strDSURL, strDSToken);
	assert(jmResult == JMSucceed);
}


/***
*	JMMeetingMgrImpl
***/
JMMeetingMgrImpl::JMMeetingMgrImpl()
{
	mpfInitialize = NULL;
	mpfReleaseResources = NULL;
	mpfNetworkChanged = NULL;
	mpfGetOnlineSwitch = NULL;
	mpfGetOfflineSwitch = NULL;
	mpfListEvents = NULL;
	mpfRefreshCalendar = NULL;
	mpfTodayChanged = NULL;
	mpfGetWbxMeetingDetail = NULL;
	mpfGetCMRInfo = NULL;
	mpfViewEvent = NULL;
	mpfGetCurrentMailType = NULL;
	mpfLaunchWebexMeeting = NULL;
	mpfSendMail = NULL;
}

JMMeetingMgrImpl::~JMMeetingMgrImpl()
{
}

void JMMeetingMgrImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_Initialize, (void**)&mpfInitialize);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_ReleaseResources, (void**)&mpfReleaseResources);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_NetworkChanged, (void**)&mpfNetworkChanged);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_GetOnlineSwitch, (void**)&mpfGetOnlineSwitch);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_GetOfflineSwitch, (void**)&mpfGetOfflineSwitch);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_ListEvents, (void**)&mpfListEvents);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_RefreshCalendar, (void**)&mpfRefreshCalendar);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_TodayChanged, (void**)&mpfTodayChanged);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_GetWbxMeetingDetail, (void**)&mpfGetWbxMeetingDetail);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_GetCMRInfo, (void**)&mpfGetCMRInfo);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_ViewEvent, (void**)&mpfViewEvent);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_GetCurrentMailType, (void**)&mpfGetCurrentMailType);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_LaunchWebexMeeting, (void**)&mpfLaunchWebexMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_JMMeetingMgr_SendMail, (void**)&mpfSendMail);
}

void JMMeetingMgrImpl::FuncUnInit()
{
	mpfInitialize = NULL;
	mpfReleaseResources = NULL;
	mpfNetworkChanged = NULL;
	mpfGetOnlineSwitch = NULL;
	mpfGetOfflineSwitch = NULL;
	mpfListEvents = NULL;
	mpfRefreshCalendar = NULL;
	mpfTodayChanged = NULL;
	mpfGetWbxMeetingDetail = NULL;
	mpfGetCMRInfo = NULL;
	mpfViewEvent = NULL;
	mpfGetCurrentMailType = NULL;
	mpfLaunchWebexMeeting = NULL;
	mpfSendMail = NULL;
}

HRESULT JMMeetingMgrImpl::Initialize(ConOIServieType const &conType)
{
	HRESULT ret;
	JMResult jmResult = (*mpfInitialize)(conType, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::ReleaseResources()
{
	HRESULT ret;
	JMResult jmResult = (*mpfReleaseResources)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::NetworkChanged(BOOL bConnected)
{
	HRESULT ret;
	JMResult jmResult = (*mpfNetworkChanged)(bConnected, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::GetOnlineSwitch(OUT BOOL * pVal)
{
	HRESULT ret;
	JMResult jmResult = (*mpfGetOnlineSwitch)(pVal, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::GetOfflineSwitch(OUT BOOL * pVal)
{
	HRESULT ret;
	JMResult jmResult = (*mpfGetOfflineSwitch)(pVal, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::ListEvents(IN const SYSTEMTIME& stSelectedDay)
{
	HRESULT ret;
	JMResult jmResult = (*mpfListEvents)(stSelectedDay, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::RefreshCalendar()
{
	HRESULT ret;
	JMResult jmResult = (*mpfRefreshCalendar)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::TodayChanged(IN BOOL bForceRefresh)
{
	HRESULT ret;
	JMResult jmResult = (*mpfTodayChanged)(bForceRefresh, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::GetWbxMeetingDetail(IN wstring const& strEventID)
{
	HRESULT ret;
	JMResult jmResult = (*mpfGetWbxMeetingDetail)(strEventID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::GetCMRInfo(IN wstring const& strMeetingKeyList)
{
	HRESULT ret;
	JMResult jmResult = (*mpfGetCMRInfo)(strMeetingKeyList, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::ViewEvent(IN wstring const& strEventID)
{
	HRESULT ret;
	JMResult jmResult = (*mpfViewEvent)(strEventID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::GetCurrentMailType(OUT ConOIServieType& conType)
{
	HRESULT ret;
	JMResult jmResult = (*mpfGetCurrentMailType)(conType, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::LaunchWebexMeeting(IN wstring const& strEventID)
{
	HRESULT ret;
	JMResult jmResult = (*mpfLaunchWebexMeeting)(strEventID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

HRESULT JMMeetingMgrImpl::SendMail(IN const wstring& strSubject, IN const wstring& strTos, IN const wstring& strBody, IN const wstring& strMeetingKey)
{
	HRESULT ret;
	JMResult jmResult = (*mpfSendMail)(strSubject, strTos, strBody, strMeetingKey, ret);
	assert(jmResult == JMSucceed);
	return ret;
}


/***
*	IWbxMeetingAccountMgrImpl
***/
IWbxMeetingAccountMgrImpl::IWbxMeetingAccountMgrImpl()
{
	mpfRegisterObserver = NULL;
	mpfUnregisterObserver = NULL;
	mpfIsActiveAccountExist = NULL;
	mpfVerifyAccount = NULL;
	mpfSetAccountEmpty = NULL;
	mpfSetActiveAccount = NULL;
	mpfNoticeInvalidCertInMeetingSite = NULL;
	mpfGetMeetingAccount = NULL;
	mpfRefreshSessionTicket = NULL;
	mpfCheckSSOSiteList = NULL;
	mpfCheckSiteSSOFlag = NULL;
	mpfGetSiteSSOFlag = NULL;
}

IWbxMeetingAccountMgrImpl::~IWbxMeetingAccountMgrImpl()
{
}

void IWbxMeetingAccountMgrImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_RegisterObserver, (void**)&mpfRegisterObserver);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_UnregisterObserver, (void**)&mpfUnregisterObserver);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_IsActiveAccountExist, (void**)&mpfIsActiveAccountExist);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_VerifyAccount, (void**)&mpfVerifyAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_SetAccountEmpty, (void**)&mpfSetAccountEmpty);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_SetActiveAccount, (void**)&mpfSetActiveAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_NoticeInvalidCertInMeetingSite, (void**)&mpfNoticeInvalidCertInMeetingSite);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_GetMeetingAccount, (void**)&mpfGetMeetingAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_RefreshSessionTicket, (void**)&mpfRefreshSessionTicket);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_CheckSSOSiteList, (void**)&mpfCheckSSOSiteList);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_CheckSiteSSOFlag, (void**)&mpfCheckSiteSSOFlag);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountMgr_GetSiteSSOFlag, (void**)&mpfGetSiteSSOFlag);
}

void IWbxMeetingAccountMgrImpl::FuncUnInit()
{
	mpfRegisterObserver = NULL;
	mpfUnregisterObserver = NULL;
	mpfIsActiveAccountExist = NULL;
	mpfVerifyAccount = NULL;
	mpfSetAccountEmpty = NULL;
	mpfSetActiveAccount = NULL;
	mpfNoticeInvalidCertInMeetingSite = NULL;
	mpfGetMeetingAccount = NULL;
	mpfRefreshSessionTicket = NULL;
	mpfCheckSSOSiteList = NULL;
	mpfCheckSiteSSOFlag = NULL;
	mpfGetSiteSSOFlag = NULL;
}

void IWbxMeetingAccountMgrImpl::RegisterObserver(IWbxMeetingAccountObserve *pOB)
{
	JMResult jmResult = (*mpfRegisterObserver)(pOB);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::UnregisterObserver(IWbxMeetingAccountObserve *pOB)
{
	JMResult jmResult = (*mpfUnregisterObserver)(pOB);
	assert(jmResult == JMSucceed);
}

bool IWbxMeetingAccountMgrImpl::IsActiveAccountExist()
{
	bool ret;
	JMResult jmResult = (*mpfIsActiveAccountExist)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IWbxMeetingAccountMgrImpl::VerifyAccount(const wstring& strSiteUrl, const wstring& strUserName, const wstring& strCred, bool bSSO)
{
	JMResult jmResult = (*mpfVerifyAccount)(strSiteUrl, strUserName, strCred, bSSO);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::SetAccountEmpty()
{
	JMResult jmResult = (*mpfSetAccountEmpty)();
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::SetActiveAccount(TWBXMeetingAccountInfo& account)
{
	JMResult jmResult = (*mpfSetActiveAccount)(account);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::NoticeInvalidCertInMeetingSite(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode)
{
	JMResult jmResult = (*mpfNoticeInvalidCertInMeetingSite)(eErrCode);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::GetMeetingAccount(TWBXMeetingAccountInfo& account)
{
	JMResult jmResult = (*mpfGetMeetingAccount)(account);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::RefreshSessionTicket(const wstring& strSessionTicket)
{
	JMResult jmResult = (*mpfRefreshSessionTicket)(strSessionTicket);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::CheckSSOSiteList(const wstring& strSiteList)
{
	JMResult jmResult = (*mpfCheckSSOSiteList)(strSiteList);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountMgrImpl::CheckSiteSSOFlag(const wstring& strSiteUrl)
{
	JMResult jmResult = (*mpfCheckSiteSSOFlag)(strSiteUrl);
	assert(jmResult == JMSucceed);
}

E_WBX_SITE_SSO_FLAG IWbxMeetingAccountMgrImpl::GetSiteSSOFlag(const wstring& strSiteUrl)
{
	E_WBX_SITE_SSO_FLAG ret;
	JMResult jmResult = (*mpfGetSiteSSOFlag)(strSiteUrl, ret);
	assert(jmResult == JMSucceed);
	return ret;
}


/***
*	IMeetingAccountInfoCallbackImpl
***/
IMeetingAccountInfoCallbackImpl::IMeetingAccountInfoCallbackImpl()
{
	mpfOnWapiGetAllAccount = NULL;
	mpfOnWapiGetDefaultAccount = NULL;
	mpfOnWapiDelAccount = NULL;
	mpfOnWapiSetAccount = NULL;
}

IMeetingAccountInfoCallbackImpl::~IMeetingAccountInfoCallbackImpl()
{
}

void IMeetingAccountInfoCallbackImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingAccountInfoCallback_OnWapiGetAllAccount, (void**)&mpfOnWapiGetAllAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingAccountInfoCallback_OnWapiGetDefaultAccount, (void**)&mpfOnWapiGetDefaultAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingAccountInfoCallback_OnWapiDelAccount, (void**)&mpfOnWapiDelAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingAccountInfoCallback_OnWapiSetAccount, (void**)&mpfOnWapiSetAccount);
}

void IMeetingAccountInfoCallbackImpl::FuncUnInit()
{
	mpfOnWapiGetAllAccount = NULL;
	mpfOnWapiGetDefaultAccount = NULL;
	mpfOnWapiDelAccount = NULL;
	mpfOnWapiSetAccount = NULL;
}

void IMeetingAccountInfoCallbackImpl::OnWapiGetAllAccount(BOOL bSuccess, vector<TWBXMeetingAccountInfo> &accounts)
{
	JMResult jmResult = (*mpfOnWapiGetAllAccount)(bSuccess, accounts);
	assert(jmResult == JMSucceed);
}

void IMeetingAccountInfoCallbackImpl::OnWapiGetDefaultAccount(BOOL bSuccess, TWBXMeetingAccountInfo &account, wstring& strSKCreateTime, wstring& strSKTime2Live, wstring strReason, int nExceptionID)
{
	JMResult jmResult = (*mpfOnWapiGetDefaultAccount)(bSuccess, account, strSKCreateTime, strSKTime2Live, strReason, nExceptionID);
	assert(jmResult == JMSucceed);
}

void IMeetingAccountInfoCallbackImpl::OnWapiDelAccount(BOOL bSuccess, INT nExceptionID, wstring& strReason)
{
	JMResult jmResult = (*mpfOnWapiDelAccount)(bSuccess, nExceptionID, strReason);
	assert(jmResult == JMSucceed);
}

void IMeetingAccountInfoCallbackImpl::OnWapiSetAccount(BOOL bSuccess, TWBXMeetingAccountInfo &account, wstring& strSKCreateTime, wstring& strSKTime2Live, wstring strReason, int nExceptionID)
{
	JMResult jmResult = (*mpfOnWapiSetAccount)(bSuccess, account, strSKCreateTime, strSKTime2Live, strReason, nExceptionID);
	assert(jmResult == JMSucceed);
}


/***
*	IInstantMeetingMgrImpl
***/
IInstantMeetingMgrImpl::IInstantMeetingMgrImpl()
{
	mpfRegisterEvent = NULL;
	mpfUnregisterEvent = NULL;
	mpfOpenOneClickSetting = NULL;
	mpfGetLastError = NULL;
	mpfIsInMeeting = NULL;
	mpfCanStartMeeting = NULL;
	mpfCanJoinMeeting = NULL;
	mpfStartInstantMeeting = NULL;
	mpfAccept = NULL;
	mpfDecline = NULL;
	mpfReinvite = NULL;
	mpfOpenMeetingDetailPage = NULL;
	mpfStartJoinMeetingByUrl = NULL;
	mpfStartScheduledMeeting = NULL;
	mpfLaunchMeetingByJoinURL = NULL;
	mpfJoinMeetingByMK = NULL;
	mpfIsMeetingInProgress = NULL;
	mpfGetJoinURL = NULL;
	mpfGetInstantMeetingInfoByMK = NULL;
	mpfStartCMRMeeting = NULL;
	mpfJoinCMRMeeting = NULL;
}

IInstantMeetingMgrImpl::~IInstantMeetingMgrImpl()
{
}

void IInstantMeetingMgrImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_RegisterEvent, (void**)&mpfRegisterEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_UnregisterEvent, (void**)&mpfUnregisterEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_OpenOneClickSetting, (void**)&mpfOpenOneClickSetting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_GetLastError, (void**)&mpfGetLastError);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_IsInMeeting, (void**)&mpfIsInMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_CanStartMeeting, (void**)&mpfCanStartMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_CanJoinMeeting, (void**)&mpfCanJoinMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_StartInstantMeeting, (void**)&mpfStartInstantMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_Accept, (void**)&mpfAccept);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_Decline, (void**)&mpfDecline);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_Reinvite, (void**)&mpfReinvite);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_OpenMeetingDetailPage, (void**)&mpfOpenMeetingDetailPage);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_StartJoinMeetingByUrl, (void**)&mpfStartJoinMeetingByUrl);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_StartScheduledMeeting, (void**)&mpfStartScheduledMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_LaunchMeetingByJoinURL, (void**)&mpfLaunchMeetingByJoinURL);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_JoinMeetingByMK, (void**)&mpfJoinMeetingByMK);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_IsMeetingInProgress, (void**)&mpfIsMeetingInProgress);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_GetJoinURL, (void**)&mpfGetJoinURL);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_GetInstantMeetingInfoByMK, (void**)&mpfGetInstantMeetingInfoByMK);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_StartCMRMeeting, (void**)&mpfStartCMRMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_JoinCMRMeeting, (void**)&mpfJoinCMRMeeting);
}

void IInstantMeetingMgrImpl::FuncUnInit()
{
	mpfRegisterEvent = NULL;
	mpfUnregisterEvent = NULL;
	mpfOpenOneClickSetting = NULL;
	mpfGetLastError = NULL;
	mpfIsInMeeting = NULL;
	mpfCanStartMeeting = NULL;
	mpfCanJoinMeeting = NULL;
	mpfStartInstantMeeting = NULL;
	mpfAccept = NULL;
	mpfDecline = NULL;
	mpfReinvite = NULL;
	mpfOpenMeetingDetailPage = NULL;
	mpfStartJoinMeetingByUrl = NULL;
	mpfStartScheduledMeeting = NULL;
	mpfLaunchMeetingByJoinURL = NULL;
	mpfJoinMeetingByMK = NULL;
	mpfIsMeetingInProgress = NULL;
	mpfGetJoinURL = NULL;
	mpfGetInstantMeetingInfoByMK = NULL;
	mpfStartCMRMeeting = NULL;
	mpfJoinCMRMeeting = NULL;
}

void IInstantMeetingMgrImpl::RegisterEvent(IInstantMeetingEvent * pEvent)
{
	JMResult jmResult = (*mpfRegisterEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::UnregisterEvent(IInstantMeetingEvent * pEvent)
{
	JMResult jmResult = (*mpfUnregisterEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::OpenOneClickSetting()
{
	JMResult jmResult = (*mpfOpenOneClickSetting)();
	assert(jmResult == JMSucceed);
}

int IInstantMeetingMgrImpl::GetLastError(wstring& strErrMsg)
{
	int ret;
	JMResult jmResult = (*mpfGetLastError)(strErrMsg, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::IsInMeeting()
{
	BOOL ret;
	JMResult jmResult = (*mpfIsInMeeting)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::CanStartMeeting()
{
	BOOL ret;
	JMResult jmResult = (*mpfCanStartMeeting)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::CanJoinMeeting(const wstring& strSessionKey)
{
	BOOL ret;
	JMResult jmResult = (*mpfCanJoinMeeting)(strSessionKey, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::StartInstantMeeting(wstring const& strMeetingName, vector<InviteeInfo> const& vecUserList, wstring const&  strDefSessionID)
{
	BOOL ret;
	JMResult jmResult = (*mpfStartInstantMeeting)(strMeetingName, vecUserList, strDefSessionID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::Accept(const wstring& strSessionName)
{
	BOOL ret;
	JMResult jmResult = (*mpfAccept)(strSessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::Decline(const wstring& strSessionName)
{
	BOOL ret;
	JMResult jmResult = (*mpfDecline)(strSessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::Reinvite(const wstring& strSessionName)
{
	BOOL ret;
	JMResult jmResult = (*mpfReinvite)(strSessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::OpenMeetingDetailPage(const TCHAR* pszJoinUrl)
{
	BOOL ret;
	JMResult jmResult = (*mpfOpenMeetingDetailPage)(pszJoinUrl, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::StartJoinMeetingByUrl(const TCHAR* pszJoinUrl)
{
	BOOL ret;
	JMResult jmResult = (*mpfStartJoinMeetingByUrl)(pszJoinUrl, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::StartScheduledMeeting(wstring const& strMeetingKey)
{
	BOOL ret;
	JMResult jmResult = (*mpfStartScheduledMeeting)(strMeetingKey, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::LaunchMeetingByJoinURL(wstring const& strJoinURL, BOOL bHost, wstring const& strEventID)
{
	BOOL ret;
	JMResult jmResult = (*mpfLaunchMeetingByJoinURL)(strJoinURL, bHost, strEventID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::JoinMeetingByMK(wstring const& strMeetingKey, wstring const& strMeetingPass)
{
	BOOL ret;
	JMResult jmResult = (*mpfJoinMeetingByMK)(strMeetingKey, strMeetingPass, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::IsMeetingInProgress(IN const wstring& strMeetingKey)
{
	BOOL ret;
	JMResult jmResult = (*mpfIsMeetingInProgress)(strMeetingKey, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::GetJoinURL(const TCHAR* pszSite, const TCHAR* pszEventID, const TCHAR* pszMeetingKey, const TCHAR* pszMeetingPwd, bool bSetMK, const TCHAR* pszEmail, const TCHAR* pszUserName, TCHAR* pszURL, unsigned long* pulURLLen, int eSenario)
{
	BOOL ret;
	JMResult jmResult = (*mpfGetJoinURL)(pszSite, pszEventID, pszMeetingKey, pszMeetingPwd, bSetMK, pszEmail, pszUserName, pszURL, pulURLLen, eSenario, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IInstantMeetingMgrImpl::GetInstantMeetingInfoByMK(const wstring& strMeetingKey, DWORD& dwSiteType, wstring& strInviteByEmail, wstring& strQSInviteURL, wstring& strInviteCode, wstring& strOfflineBuddies, BOOL& bFromClient, BOOL& bHost)
{
	JMResult jmResult = (*mpfGetInstantMeetingInfoByMK)(strMeetingKey, dwSiteType, strInviteByEmail, strQSInviteURL, strInviteCode, strOfflineBuddies, bFromClient, bHost);
	assert(jmResult == JMSucceed);
}

BOOL IInstantMeetingMgrImpl::StartCMRMeeting(BOOL isLaunchMeeting)
{
	BOOL ret;
	JMResult jmResult = (*mpfStartCMRMeeting)(isLaunchMeeting, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IInstantMeetingMgrImpl::JoinCMRMeeting(wstring const& strSiteURL, wstring const& strMeetingKey, wstring const& strMTGTK)
{
	BOOL ret;
	JMResult jmResult = (*mpfJoinCMRMeeting)(strSiteURL, strMeetingKey, strMTGTK, ret);
	assert(jmResult == JMSucceed);
	return ret;
}


/***
*	IDSMgrImpl
***/
IDSMgrImpl::IDSMgrImpl()
{
	mpfCancelStartSharing = NULL;
	mpfCanStartSharing = NULL;
	mpfIsInsharing = NULL;
	mpfStart = NULL;
	mpfJoin = NULL;
	mpfDecline = NULL;
	mpfStopCurSession = NULL;
	mpfReInviteCurSession = NULL;
	mpfReSharing = NULL;
	mpfChangePresenter = NULL;
	mpfIsPresenter = NULL;
	mpfCanJoinSharing = NULL;
}

IDSMgrImpl::~IDSMgrImpl()
{
}

void IDSMgrImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_CancelStartSharing, (void**)&mpfCancelStartSharing);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_CanStartSharing, (void**)&mpfCanStartSharing);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_IsInsharing, (void**)&mpfIsInsharing);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_Start, (void**)&mpfStart);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_Join, (void**)&mpfJoin);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_Decline, (void**)&mpfDecline);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_StopCurSession, (void**)&mpfStopCurSession);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_ReInviteCurSession, (void**)&mpfReInviteCurSession);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_ReSharing, (void**)&mpfReSharing);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_ChangePresenter, (void**)&mpfChangePresenter);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_IsPresenter, (void**)&mpfIsPresenter);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_CanJoinSharing, (void**)&mpfCanJoinSharing);
}

void IDSMgrImpl::FuncUnInit()
{
	mpfCancelStartSharing = NULL;
	mpfCanStartSharing = NULL;
	mpfIsInsharing = NULL;
	mpfStart = NULL;
	mpfJoin = NULL;
	mpfDecline = NULL;
	mpfStopCurSession = NULL;
	mpfReInviteCurSession = NULL;
	mpfReSharing = NULL;
	mpfChangePresenter = NULL;
	mpfIsPresenter = NULL;
	mpfCanJoinSharing = NULL;
}

BOOL IDSMgrImpl::CancelStartSharing()
{
	BOOL ret;
	JMResult jmResult = (*mpfCancelStartSharing)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::CanStartSharing(const wstring& strSessionName)
{
	BOOL ret;
	JMResult jmResult = (*mpfCanStartSharing)(strSessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::IsInsharing()
{
	BOOL ret;
	JMResult jmResult = (*mpfIsInsharing)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::Start(const wstring& strSessionName)
{
	BOOL ret;
	JMResult jmResult = (*mpfStart)(strSessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::Join(const wstring& strSessionName)
{
	BOOL ret;
	JMResult jmResult = (*mpfJoin)(strSessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::Decline(const wstring& strSessionName)
{
	BOOL ret;
	JMResult jmResult = (*mpfDecline)(strSessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::StopCurSession()
{
	BOOL ret;
	JMResult jmResult = (*mpfStopCurSession)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::ReInviteCurSession()
{
	BOOL ret;
	JMResult jmResult = (*mpfReInviteCurSession)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::ReSharing()
{
	BOOL ret;
	JMResult jmResult = (*mpfReSharing)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::ChangePresenter()
{
	BOOL ret;
	JMResult jmResult = (*mpfChangePresenter)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::IsPresenter()
{
	BOOL ret;
	JMResult jmResult = (*mpfIsPresenter)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

BOOL IDSMgrImpl::CanJoinSharing(const wstring& strSessionName, INT& eType)
{
	BOOL ret;
	JMResult jmResult = (*mpfCanJoinSharing)(strSessionName, eType, ret);
	assert(jmResult == JMSucceed);
	return ret;
}


/***
*	IJMIMDelegeteWrapper
***/
IJMIMDelegete* IJMIMDelegeteWrapper::m_pIJMIMDelegete = NULL;
void IJMIMDelegeteWrapper::SetHandler(IJMIMDelegete* pIJMIMDelegete)
{
	m_pIJMIMDelegete = pIJMIMDelegete;
}

void IJMIMDelegeteWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMIMDelegete_SendCmd_DSInvitation, (void*)&IJMIMDelegeteWrapper::SendCmd_DSInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMIMDelegete_SendCmd_DSDecline, (void*)&IJMIMDelegeteWrapper::SendCmd_DSDecline);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMIMDelegete_SendCmd_DSCancelled, (void*)&IJMIMDelegeteWrapper::SendCmd_DSCancelled);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMIMDelegete_SendCmd_MeetingInvitation, (void*)&IJMIMDelegeteWrapper::SendCmd_MeetingInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMIMDelegete_SendCmd_MeetingDecline, (void*)&IJMIMDelegeteWrapper::SendCmd_MeetingDecline);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMIMDelegete_SendCmd_MeetingCancelled, (void*)&IJMIMDelegeteWrapper::SendCmd_MeetingCancelled);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMIMDelegete_SendCmd_IMAlert, (void*)&IJMIMDelegeteWrapper::SendCmd_IMAlert);
}

BOOL IJMIMDelegeteWrapper::SendCmd_DSInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage)
{
	if(m_pIJMIMDelegete != NULL)
	{
		return m_pIJMIMDelegete->SendCmd_DSInvitation(strBuddyName, strCmd, strHtmlMessage, strPlainMessage);
	}
	return FALSE;
}

BOOL IJMIMDelegeteWrapper::SendCmd_DSDecline(wstring& strSessionName, wstring& strCmdMsg)
{
	if(m_pIJMIMDelegete != NULL)
	{
		return m_pIJMIMDelegete->SendCmd_DSDecline(strSessionName, strCmdMsg);
	}
	return FALSE;
}

BOOL IJMIMDelegeteWrapper::SendCmd_DSCancelled(wstring& strSessionName, wstring& strCmdMsg)
{
	if(m_pIJMIMDelegete != NULL)
	{
		return m_pIJMIMDelegete->SendCmd_DSCancelled(strSessionName, strCmdMsg);
	}
	return FALSE;
}

BOOL IJMIMDelegeteWrapper::SendCmd_MeetingInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage)
{
	if(m_pIJMIMDelegete != NULL)
	{
		return m_pIJMIMDelegete->SendCmd_MeetingInvitation(strBuddyName, strCmd, strHtmlMessage, strPlainMessage);
	}
	return FALSE;
}

BOOL IJMIMDelegeteWrapper::SendCmd_MeetingDecline(wstring& strSessionName, wstring& strCmdMsg)
{
	if(m_pIJMIMDelegete != NULL)
	{
		return m_pIJMIMDelegete->SendCmd_MeetingDecline(strSessionName, strCmdMsg);
	}
	return FALSE;
}

BOOL IJMIMDelegeteWrapper::SendCmd_MeetingCancelled(wstring& strSessionName, wstring& strCmdMsg)
{
	if(m_pIJMIMDelegete != NULL)
	{
		return m_pIJMIMDelegete->SendCmd_MeetingCancelled(strSessionName, strCmdMsg);
	}
	return FALSE;
}

BOOL IJMIMDelegeteWrapper::SendCmd_IMAlert(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage)
{
	if(m_pIJMIMDelegete != NULL)
	{
		return m_pIJMIMDelegete->SendCmd_IMAlert(strBuddyName, strCmd, strHtmlMessage, strPlainMessage);
	}
	return FALSE;
}


/***
*	ICommonDependenciesDelegateWrapper
***/
ICommonDependenciesDelegate* ICommonDependenciesDelegateWrapper::m_pICommonDependenciesDelegate = NULL;
void ICommonDependenciesDelegateWrapper::SetHandler(ICommonDependenciesDelegate* pICommonDependenciesDelegate)
{
	m_pICommonDependenciesDelegate = pICommonDependenciesDelegate;
}

void ICommonDependenciesDelegateWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetMyAccountName, (void*)&ICommonDependenciesDelegateWrapper::GetMyAccountName);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetMyAccountDisplayName, (void*)&ICommonDependenciesDelegateWrapper::GetMyAccountDisplayName);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetMyAccountEmail, (void*)&ICommonDependenciesDelegateWrapper::GetMyAccountEmail);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetBuddyDispName, (void*)&ICommonDependenciesDelegateWrapper::GetBuddyDispName);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetBuddyEmail, (void*)&ICommonDependenciesDelegateWrapper::GetBuddyEmail);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetBuddyURIWithEmailaddress, (void*)&ICommonDependenciesDelegateWrapper::GetBuddyURIWithEmailaddress);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_IsAccount, (void*)&ICommonDependenciesDelegateWrapper::IsAccount);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_IsSignedOn, (void*)&ICommonDependenciesDelegateWrapper::IsSignedOn);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_IsDSPolicyEnable, (void*)&ICommonDependenciesDelegateWrapper::IsDSPolicyEnable);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_AutoRespPolicy, (void*)&ICommonDependenciesDelegateWrapper::AutoRespPolicy);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_HasDSCapability, (void*)&ICommonDependenciesDelegateWrapper::HasDSCapability);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_HasIMCapability, (void*)&ICommonDependenciesDelegateWrapper::HasIMCapability);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_IsBuddyOnline, (void*)&ICommonDependenciesDelegateWrapper::IsBuddyOnline);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_IsCupMode, (void*)&ICommonDependenciesDelegateWrapper::IsCupMode);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_IsWbxMeetingEnabled, (void*)&ICommonDependenciesDelegateWrapper::IsWbxMeetingEnabled);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetDSURL, (void*)&ICommonDependenciesDelegateWrapper::GetDSURL);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetDSToken, (void*)&ICommonDependenciesDelegateWrapper::GetDSToken);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetDSParam, (void*)&ICommonDependenciesDelegateWrapper::GetDSParam);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_ProbeP2PDnd, (void*)&ICommonDependenciesDelegateWrapper::ProbeP2PDnd);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_AutoRespDnd, (void*)&ICommonDependenciesDelegateWrapper::AutoRespDnd);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_AddInMeetingStatus, (void*)&ICommonDependenciesDelegateWrapper::AddInMeetingStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_RemoveInMeetingStatus, (void*)&ICommonDependenciesDelegateWrapper::RemoveInMeetingStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_AddInWebExMeetingStatus, (void*)&ICommonDependenciesDelegateWrapper::AddInWebExMeetingStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_RemoveInWebExMeetingStatus, (void*)&ICommonDependenciesDelegateWrapper::RemoveInWebExMeetingStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_AddSharingInWebExMeetingStatus, (void*)&ICommonDependenciesDelegateWrapper::AddSharingInWebExMeetingStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_RemoveSharingInWebExMeetingStatus, (void*)&ICommonDependenciesDelegateWrapper::RemoveSharingInWebExMeetingStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_AddInDSStatus, (void*)&ICommonDependenciesDelegateWrapper::AddInDSStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_RemoveInDSStatus, (void*)&ICommonDependenciesDelegateWrapper::RemoveInDSStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_AddSharingInDSStatus, (void*)&ICommonDependenciesDelegateWrapper::AddSharingInDSStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_RemoveSharingInDSStatus, (void*)&ICommonDependenciesDelegateWrapper::RemoveSharingInDSStatus);
	jmResult = (*pfEventCallbackSet)(JMSDK_ICommonDependenciesDelegate_GetCalendarAutoRefreshTime, (void*)&ICommonDependenciesDelegateWrapper::GetCalendarAutoRefreshTime);
}

wstring ICommonDependenciesDelegateWrapper::GetMyAccountName()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetMyAccountName();
	}
	return L"";
}

wstring ICommonDependenciesDelegateWrapper::GetMyAccountDisplayName()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetMyAccountDisplayName();
	}
	return L"";
}

wstring ICommonDependenciesDelegateWrapper::GetMyAccountEmail()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetMyAccountEmail();
	}
	return L"";
}

wstring ICommonDependenciesDelegateWrapper::GetBuddyDispName(const wstring& strURI)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetBuddyDispName(strURI);
	}
	return L"";
}

wstring ICommonDependenciesDelegateWrapper::GetBuddyEmail(const wstring &strBuddyName)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetBuddyEmail(strBuddyName);
	}
	return L"";
}

wstring ICommonDependenciesDelegateWrapper::GetBuddyURIWithEmailaddress(const wstring& strEmailaddress)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetBuddyURIWithEmailaddress(strEmailaddress);
	}
	return L"";
}

BOOL ICommonDependenciesDelegateWrapper::IsAccount(const wstring& strSessionName)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->IsAccount(strSessionName);
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::IsSignedOn()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->IsSignedOn();
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::IsDSPolicyEnable(const wstring& strSessionName, int& nPolicyResult)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->IsDSPolicyEnable(strSessionName, nPolicyResult);
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::AutoRespPolicy(wstring const& strBuddyName, int nPolicyResult)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->AutoRespPolicy(strBuddyName, nPolicyResult);
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::HasDSCapability(const wstring& strSessionName)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->HasDSCapability(strSessionName);
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::HasIMCapability(const wstring& strSessionName)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->HasIMCapability(strSessionName);
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::IsBuddyOnline(const wstring& strSessionName)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->IsBuddyOnline(strSessionName);
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::IsCupMode()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->IsCupMode();
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::IsWbxMeetingEnabled()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->IsWbxMeetingEnabled();
	}
	return FALSE;
}

wstring ICommonDependenciesDelegateWrapper::GetDSURL()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetDSURL();
	}
	return L"";
}

wstring ICommonDependenciesDelegateWrapper::GetDSToken()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetDSToken();
	}
	return L"";
}

wstring ICommonDependenciesDelegateWrapper::GetDSParam()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetDSParam();
	}
	return L"";
}

BOOL ICommonDependenciesDelegateWrapper::ProbeP2PDnd(wstring const& strBuddyName)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->ProbeP2PDnd(strBuddyName);
	}
	return FALSE;
}

BOOL ICommonDependenciesDelegateWrapper::AutoRespDnd(wstring const& strBuddyName)
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->AutoRespDnd(strBuddyName);
	}
	return FALSE;
}

void ICommonDependenciesDelegateWrapper::AddInMeetingStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->AddInMeetingStatus();
	}
}

void ICommonDependenciesDelegateWrapper::RemoveInMeetingStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->RemoveInMeetingStatus();
	}
}

void ICommonDependenciesDelegateWrapper::AddInWebExMeetingStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->AddInWebExMeetingStatus();
	}
}

void ICommonDependenciesDelegateWrapper::RemoveInWebExMeetingStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->RemoveInWebExMeetingStatus();
	}
}

void ICommonDependenciesDelegateWrapper::AddSharingInWebExMeetingStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->AddSharingInWebExMeetingStatus();
	}
}

void ICommonDependenciesDelegateWrapper::RemoveSharingInWebExMeetingStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->RemoveSharingInWebExMeetingStatus();
	}
}

void ICommonDependenciesDelegateWrapper::AddInDSStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->AddInDSStatus();
	}
}

void ICommonDependenciesDelegateWrapper::RemoveInDSStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->RemoveInDSStatus();
	}
}

void ICommonDependenciesDelegateWrapper::AddSharingInDSStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->AddSharingInDSStatus();
	}
}

void ICommonDependenciesDelegateWrapper::RemoveSharingInDSStatus()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		m_pICommonDependenciesDelegate->RemoveSharingInDSStatus();
	}
}

unsigned int ICommonDependenciesDelegateWrapper::GetCalendarAutoRefreshTime()
{
	if(m_pICommonDependenciesDelegate != NULL)
	{
		return m_pICommonDependenciesDelegate->GetCalendarAutoRefreshTime();
	}
	return 0;
}


/***
*	JMLoggerWrapper
***/
JMLogger* JMLoggerWrapper::m_pJMLogger = NULL;
void JMLoggerWrapper::SetHandler(JMLogger* pJMLogger)
{
	m_pJMLogger = pJMLogger;
}

void JMLoggerWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_JMLogger_log, (void*)&JMLoggerWrapper::log);
}

void JMLoggerWrapper::log(int level, const char *sourceFile, int sourceLine, const char* function, const char* fmt, va_list args)
{
	if(m_pJMLogger != NULL)
	{
		m_pJMLogger->log(level, sourceFile, sourceLine, function, fmt, args);
	}
}


/***
*	JMMeetingMgrHandlerWrapper
***/
JMMeetingMgrHandler* JMMeetingMgrHandlerWrapper::m_pJMMeetingMgrHandler = NULL;
void JMMeetingMgrHandlerWrapper::SetHandler(JMMeetingMgrHandler* pJMMeetingMgrHandler)
{
	m_pJMMeetingMgrHandler = pJMMeetingMgrHandler;
}

void JMMeetingMgrHandlerWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnListOneDayEvents, (void*)&JMMeetingMgrHandlerWrapper::OnListOneDayEvents);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnMeetingStart, (void*)&JMMeetingMgrHandlerWrapper::OnMeetingStart);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnMeetingEnd, (void*)&JMMeetingMgrHandlerWrapper::OnMeetingEnd);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnOvernight, (void*)&JMMeetingMgrHandlerWrapper::OnOvernight);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnGetWbxMeetingDetail, (void*)&JMMeetingMgrHandlerWrapper::OnGetWbxMeetingDetail);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnInitializeOIFailed, (void*)&JMMeetingMgrHandlerWrapper::OnInitializeOIFailed);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnInitializeResult, (void*)&JMMeetingMgrHandlerWrapper::OnInitializeResult);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnMeetingReminderHappened, (void*)&JMMeetingMgrHandlerWrapper::OnMeetingReminderHappened);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnMeetingReminderEnded, (void*)&JMMeetingMgrHandlerWrapper::OnMeetingReminderEnded);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnMeetingIMAlertHappened, (void*)&JMMeetingMgrHandlerWrapper::OnMeetingIMAlertHappened);
	jmResult = (*pfEventCallbackSet)(JMSDK_JMMeetingMgrHandler_OnGetCMRInfo, (void*)&JMMeetingMgrHandlerWrapper::OnGetCMRInfo);
}

void JMMeetingMgrHandlerWrapper::OnListOneDayEvents(wstring const& strEvents)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnListOneDayEvents(strEvents);
	}
}

void JMMeetingMgrHandlerWrapper::OnMeetingStart(wstring const& strEventID, wstring const& strMeetingKey)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnMeetingStart(strEventID, strMeetingKey);
	}
}

void JMMeetingMgrHandlerWrapper::OnMeetingEnd(wstring const& strEventID, wstring const& strMeetingKey)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnMeetingEnd(strEventID, strMeetingKey);
	}
}

void JMMeetingMgrHandlerWrapper::OnOvernight(MeetingMgrErrorCode eRet)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnOvernight(eRet);
	}
}

void JMMeetingMgrHandlerWrapper::OnGetWbxMeetingDetail(wstring const& strEventXML, wstring const& strMeetingDetail)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnGetWbxMeetingDetail(strEventXML, strMeetingDetail);
	}
}

void JMMeetingMgrHandlerWrapper::OnInitializeOIFailed()
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnInitializeOIFailed();
	}
}

void JMMeetingMgrHandlerWrapper::OnInitializeResult(LONG const &lResult)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnInitializeResult(lResult);
	}
}

void JMMeetingMgrHandlerWrapper::OnMeetingReminderHappened(MeetingReminderItem const& objMeetingReminderItem)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnMeetingReminderHappened(objMeetingReminderItem);
	}
}

void JMMeetingMgrHandlerWrapper::OnMeetingReminderEnded(wstring const & strEventID)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnMeetingReminderEnded(strEventID);
	}
}

void JMMeetingMgrHandlerWrapper::OnMeetingIMAlertHappened(MeetingIMAlertItem const &obj)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnMeetingIMAlertHappened(obj);
	}
}

void JMMeetingMgrHandlerWrapper::OnGetCMRInfo(const wstring& cmrInfo)
{
	if(m_pJMMeetingMgrHandler != NULL)
	{
		m_pJMMeetingMgrHandler->OnGetCMRInfo(cmrInfo);
	}
}


/***
*	IWbxMeetingAccountObserveWrapper
***/
IWbxMeetingAccountObserve* IWbxMeetingAccountObserveWrapper::m_pIWbxMeetingAccountObserve = NULL;
void IWbxMeetingAccountObserveWrapper::SetHandler(IWbxMeetingAccountObserve* pIWbxMeetingAccountObserve)
{
	m_pIWbxMeetingAccountObserve = pIWbxMeetingAccountObserve;
}

void IWbxMeetingAccountObserveWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountObserve_OnVerifyAccount, (void*)&IWbxMeetingAccountObserveWrapper::OnVerifyAccount);
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountObserve_OnNoticeActiveAccountChange, (void*)&IWbxMeetingAccountObserveWrapper::OnNoticeActiveAccountChange);
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountObserve_OnNoticeSessionTicketRefreshed, (void*)&IWbxMeetingAccountObserveWrapper::OnNoticeSessionTicketRefreshed);
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountObserve_OnNoticeInvalidCertInMeetingSite, (void*)&IWbxMeetingAccountObserveWrapper::OnNoticeInvalidCertInMeetingSite);
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountObserve_OnCheckSSOSiteListReady, (void*)&IWbxMeetingAccountObserveWrapper::OnCheckSSOSiteListReady);
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountObserve_OnCheckSiteSSOFlagReady, (void*)&IWbxMeetingAccountObserveWrapper::OnCheckSiteSSOFlagReady);
}

void IWbxMeetingAccountObserveWrapper::OnVerifyAccount(bool bSuccess, TWBXMeetingAccountInfo * pAccount, JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode)
{
	if(m_pIWbxMeetingAccountObserve != NULL)
	{
		m_pIWbxMeetingAccountObserve->OnVerifyAccount(bSuccess, pAccount, eErrCode);
	}
}

void IWbxMeetingAccountObserveWrapper::OnNoticeActiveAccountChange(bool bExistActiveAccount)
{
	if(m_pIWbxMeetingAccountObserve != NULL)
	{
		m_pIWbxMeetingAccountObserve->OnNoticeActiveAccountChange(bExistActiveAccount);
	}
}

void IWbxMeetingAccountObserveWrapper::OnNoticeSessionTicketRefreshed(const wstring& strSessionTicket)
{
	if(m_pIWbxMeetingAccountObserve != NULL)
	{
		m_pIWbxMeetingAccountObserve->OnNoticeSessionTicketRefreshed(strSessionTicket);
	}
}

void IWbxMeetingAccountObserveWrapper::OnNoticeInvalidCertInMeetingSite(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode)
{
	if(m_pIWbxMeetingAccountObserve != NULL)
	{
		m_pIWbxMeetingAccountObserve->OnNoticeInvalidCertInMeetingSite(eErrCode);
	}
}

void IWbxMeetingAccountObserveWrapper::OnCheckSSOSiteListReady()
{
	if(m_pIWbxMeetingAccountObserve != NULL)
	{
		m_pIWbxMeetingAccountObserve->OnCheckSSOSiteListReady();
	}
}

void IWbxMeetingAccountObserveWrapper::OnCheckSiteSSOFlagReady(const wstring& strSiteUrl, E_WBX_SITE_SSO_FLAG flag)
{
	if(m_pIWbxMeetingAccountObserve != NULL)
	{
		m_pIWbxMeetingAccountObserve->OnCheckSiteSSOFlagReady(strSiteUrl, flag);
	}
}


/***
*	IMeetingAccountInfoDelegateWrapper
***/
IMeetingAccountInfoDelegate* IMeetingAccountInfoDelegateWrapper::m_pIMeetingAccountInfoDelegate = NULL;
void IMeetingAccountInfoDelegateWrapper::SetHandler(IMeetingAccountInfoDelegate* pIMeetingAccountInfoDelegate)
{
	m_pIMeetingAccountInfoDelegate = pIMeetingAccountInfoDelegate;
}

void IMeetingAccountInfoDelegateWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingAccountInfoDelegate_GetWbxAccountsAssocAsync, (void*)&IMeetingAccountInfoDelegateWrapper::GetWbxAccountsAssocAsync);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingAccountInfoDelegate_GetDefWbxAccountAsync, (void*)&IMeetingAccountInfoDelegateWrapper::GetDefWbxAccountAsync);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingAccountInfoDelegate_SetDefWbxAccountAsync, (void*)&IMeetingAccountInfoDelegateWrapper::SetDefWbxAccountAsync);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingAccountInfoDelegate_DelWbxAccountAssocAsync, (void*)&IMeetingAccountInfoDelegateWrapper::DelWbxAccountAssocAsync);
}

HRESULT IMeetingAccountInfoDelegateWrapper::GetWbxAccountsAssocAsync()
{
	if(m_pIMeetingAccountInfoDelegate != NULL)
	{
		return m_pIMeetingAccountInfoDelegate->GetWbxAccountsAssocAsync();
	}
	return 0;
}

HRESULT IMeetingAccountInfoDelegateWrapper::GetDefWbxAccountAsync()
{
	if(m_pIMeetingAccountInfoDelegate != NULL)
	{
		return m_pIMeetingAccountInfoDelegate->GetDefWbxAccountAsync();
	}
	return 0;
}

HRESULT IMeetingAccountInfoDelegateWrapper::SetDefWbxAccountAsync(wstring const& strSite, wstring const& strUser, wstring const& strPwd, BOOL isSSO)
{
	if(m_pIMeetingAccountInfoDelegate != NULL)
	{
		return m_pIMeetingAccountInfoDelegate->SetDefWbxAccountAsync(strSite, strUser, strPwd, isSSO);
	}
	return 0;
}

HRESULT IMeetingAccountInfoDelegateWrapper::DelWbxAccountAssocAsync(wstring const& strSite)
{
	if(m_pIMeetingAccountInfoDelegate != NULL)
	{
		return m_pIMeetingAccountInfoDelegate->DelWbxAccountAssocAsync(strSite);
	}
	return 0;
}


/***
*	IInstantMeetingEventWrapper
***/
IInstantMeetingEvent* IInstantMeetingEventWrapper::m_pIInstantMeetingEvent = NULL;
void IInstantMeetingEventWrapper::SetHandler(IInstantMeetingEvent* pIInstantMeetingEvent)
{
	m_pIInstantMeetingEvent = pIInstantMeetingEvent;
}

void IInstantMeetingEventWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnMeetingStart, (void*)&IInstantMeetingEventWrapper::OnMeetingStart);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnMeetingError, (void*)&IInstantMeetingEventWrapper::OnMeetingError);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnMeetingEnd, (void*)&IInstantMeetingEventWrapper::OnMeetingEnd);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnMeetingInvitation, (void*)&IInstantMeetingEventWrapper::OnMeetingInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnMeetingCancelInvitation, (void*)&IInstantMeetingEventWrapper::OnMeetingCancelInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnMeetingDecline, (void*)&IInstantMeetingEventWrapper::OnMeetingDecline);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnPopupWaitDialog, (void*)&IInstantMeetingEventWrapper::OnPopupWaitDialog);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnCloseWaitDialog, (void*)&IInstantMeetingEventWrapper::OnCloseWaitDialog);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnShowErrorDialog, (void*)&IInstantMeetingEventWrapper::OnShowErrorDialog);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnGetShortJoinURL, (void*)&IInstantMeetingEventWrapper::OnGetShortJoinURL);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnCMRMeetingStarted, (void*)&IInstantMeetingEventWrapper::OnCMRMeetingStarted);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnCMRMeetingJoined, (void*)&IInstantMeetingEventWrapper::OnCMRMeetingJoined);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnCMRMeetingFailed, (void*)&IInstantMeetingEventWrapper::OnCMRMeetingFailed);
	jmResult = (*pfEventCallbackSet)(JMSDK_IInstantMeetingEvent_OnCMRMeetingEnded, (void*)&IInstantMeetingEventWrapper::OnCMRMeetingEnded);
}

void IInstantMeetingEventWrapper::OnMeetingStart(wstring const& strMeetingKey, wstring const& strSessionName, BOOL bHost)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnMeetingStart(strMeetingKey, strSessionName, bHost);
	}
}

void IInstantMeetingEventWrapper::OnMeetingError(wstring const& strMeetingKey, wstring const& strSessionName, BOOL bHost)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnMeetingError(strMeetingKey, strSessionName, bHost);
	}
}

void IInstantMeetingEventWrapper::OnMeetingEnd(wstring const& strMeetingKey, wstring const& strSessionName, BOOL vbHost)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnMeetingEnd(strMeetingKey, strSessionName, vbHost);
	}
}

void IInstantMeetingEventWrapper::OnMeetingInvitation(wstring const& strSessionName)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnMeetingInvitation(strSessionName);
	}
}

void IInstantMeetingEventWrapper::OnMeetingCancelInvitation(wstring const& strSessionName)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnMeetingCancelInvitation(strSessionName);
	}
}

void IInstantMeetingEventWrapper::OnMeetingDecline(wstring const& strSessionName, wstring const& strBuddyName)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnMeetingDecline(strSessionName, strBuddyName);
	}
}

void IInstantMeetingEventWrapper::OnPopupWaitDialog()
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnPopupWaitDialog();
	}
}

void IInstantMeetingEventWrapper::OnCloseWaitDialog()
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnCloseWaitDialog();
	}
}

void IInstantMeetingEventWrapper::OnShowErrorDialog(int nErrorCode)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnShowErrorDialog(nErrorCode);
	}
}

void IInstantMeetingEventWrapper::OnGetShortJoinURL(wstring const& pszSiteURL, wstring const& strEventID, wstring const& pszMeetingKey, wstring const& pszShortJoinURL, int eSenario)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnGetShortJoinURL(pszSiteURL, strEventID, pszMeetingKey, pszShortJoinURL, eSenario);
	}
}

void IInstantMeetingEventWrapper::OnCMRMeetingStarted(const CMR_MeetingData & info)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnCMRMeetingStarted(info);
	}
}

void IInstantMeetingEventWrapper::OnCMRMeetingJoined(const CMR_MeetingData & info)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnCMRMeetingJoined(info);
	}
}

void IInstantMeetingEventWrapper::OnCMRMeetingFailed(int nErrorCode)
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnCMRMeetingFailed(nErrorCode);
	}
}

void IInstantMeetingEventWrapper::OnCMRMeetingEnded()
{
	if(m_pIInstantMeetingEvent != NULL)
	{
		m_pIInstantMeetingEvent->OnCMRMeetingEnded();
	}
}


/***
*	IDSMgrEventWrapper
***/
IDSMgrEvent* IDSMgrEventWrapper::m_pIDSMgrEvent = NULL;
void IDSMgrEventWrapper::SetHandler(IDSMgrEvent* pIDSMgrEvent)
{
	m_pIDSMgrEvent = pIDSMgrEvent;
}

void IDSMgrEventWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnStartingDialogShow, (void*)&IDSMgrEventWrapper::OnStartingDialogShow);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnNotifyUIUpdate, (void*)&IDSMgrEventWrapper::OnNotifyUIUpdate);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnSessionStarted, (void*)&IDSMgrEventWrapper::OnSessionStarted);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnSessionEnded, (void*)&IDSMgrEventWrapper::OnSessionEnded);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnSessionFailed, (void*)&IDSMgrEventWrapper::OnSessionFailed);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnSessionStopped, (void*)&IDSMgrEventWrapper::OnSessionStopped);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnRecvSessionInvitation, (void*)&IDSMgrEventWrapper::OnRecvSessionInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnDeclineInvitation, (void*)&IDSMgrEventWrapper::OnDeclineInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnRequestOpenChat, (void*)&IDSMgrEventWrapper::OnRequestOpenChat);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnRequestMinimizeChat, (void*)&IDSMgrEventWrapper::OnRequestMinimizeChat);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnUserJoined, (void*)&IDSMgrEventWrapper::OnUserJoined);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnUserTryLeave, (void*)&IDSMgrEventWrapper::OnUserTryLeave);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnUserLeft, (void*)&IDSMgrEventWrapper::OnUserLeft);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnCleanSession, (void*)&IDSMgrEventWrapper::OnCleanSession);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnCleanUp, (void*)&IDSMgrEventWrapper::OnCleanUp);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnErrorMsg, (void*)&IDSMgrEventWrapper::OnErrorMsg);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSMgrEvent_OnPresenterDidChange, (void*)&IDSMgrEventWrapper::OnPresenterDidChange);
}

void IDSMgrEventWrapper::OnStartingDialogShow(bool bShow)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnStartingDialogShow(bShow);
	}
}

void IDSMgrEventWrapper::OnNotifyUIUpdate()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnNotifyUIUpdate();
	}
}

void IDSMgrEventWrapper::OnSessionStarted(const wstring& strSessionName)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnSessionStarted(strSessionName);
	}
}

void IDSMgrEventWrapper::OnSessionEnded()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnSessionEnded();
	}
}

void IDSMgrEventWrapper::OnSessionFailed(INT eType)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnSessionFailed(eType);
	}
}

void IDSMgrEventWrapper::OnSessionStopped()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnSessionStopped();
	}
}

void IDSMgrEventWrapper::OnRecvSessionInvitation(const wstring& strSessionName)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnRecvSessionInvitation(strSessionName);
	}
}

void IDSMgrEventWrapper::OnDeclineInvitation(const wstring& strSessionName)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnDeclineInvitation(strSessionName);
	}
}

void IDSMgrEventWrapper::OnRequestOpenChat()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnRequestOpenChat();
	}
}

void IDSMgrEventWrapper::OnRequestMinimizeChat()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnRequestMinimizeChat();
	}
}

void IDSMgrEventWrapper::OnUserJoined()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnUserJoined();
	}
}

void IDSMgrEventWrapper::OnUserTryLeave(BOOL bHost)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnUserTryLeave(bHost);
	}
}

void IDSMgrEventWrapper::OnUserLeft()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnUserLeft();
	}
}

void IDSMgrEventWrapper::OnCleanSession(const wstring strSessionName)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnCleanSession(strSessionName);
	}
}

void IDSMgrEventWrapper::OnCleanUp()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnCleanUp();
	}
}

void IDSMgrEventWrapper::OnErrorMsg(const wstring& strSessionName, INT eType)
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnErrorMsg(strSessionName, eType);
	}
}

void IDSMgrEventWrapper::OnPresenterDidChange()
{
	if(m_pIDSMgrEvent != NULL)
	{
		m_pIDSMgrEvent->OnPresenterDidChange();
	}
}


/***
*	JMProxyWrapper
***/
JMProxy* JMProxyWrapper::m_pJMProxy = NULL;
void JMProxyWrapper::SetHandler(JMProxy* pJMProxy)
{
	m_pJMProxy = pJMProxy;
}

void JMProxyWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_JMProxy_getProxy, (void*)&JMProxyWrapper::getProxy);
}

bool JMProxyWrapper::getProxy(const char *url, string &strServer, unsigned short &port, unsigned int &proxyType, unsigned int &proxyAuth, string &strUsername, string &strPassword, string &strBypass)
{
	if(m_pJMProxy != NULL)
	{
		return m_pJMProxy->getProxy(url, strServer, port, proxyType, proxyAuth, strUsername, strPassword, strBypass);
	}
	return false;
}


/***
*	INetworkTransportWrapper
***/
INetworkTransport* INetworkTransportWrapper::m_pINetworkTransport = NULL;
void INetworkTransportWrapper::SetHandler(INetworkTransport* pINetworkTransport)
{
	m_pINetworkTransport = pINetworkTransport;
}

void INetworkTransportWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)GetProcAddress(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_INetworkTransport_HttpRequest, (void*)&INetworkTransportWrapper::HttpRequest);
	jmResult = (*pfEventCallbackSet)(JMSDK_INetworkTransport_HttpRequestAsync, (void*)&INetworkTransportWrapper::HttpRequestAsync);
	jmResult = (*pfEventCallbackSet)(JMSDK_INetworkTransport_Registered, (void*)&INetworkTransportWrapper::Registered);
}

void INetworkTransportWrapper::HttpRequest(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc)
{
	if(m_pINetworkTransport != NULL)
	{
		m_pINetworkTransport->HttpRequest(httpUrl, httpHeader, httpPostData, httpMethod, successProc, errorProc);
	}
}

void INetworkTransportWrapper::HttpRequestAsync(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc)
{
	if(m_pINetworkTransport != NULL)
	{
		m_pINetworkTransport->HttpRequestAsync(httpUrl, httpHeader, httpPostData, httpMethod, successProc, errorProc);
	}
}

bool INetworkTransportWrapper::Registered()
{
	if(m_pINetworkTransport != NULL)
	{
		return m_pINetworkTransport->Registered();
	}
	return false;
}

